<?php

namespace App\Http\Controllers;

use App\Models\ProductDetail;
use App\Http\Requests\Product\ProductDetailRequest;
use App\Http\Resources\ProductDetailResource;
use App\Models\Product;

class ProductDetailController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $productDetails = ProductDetail::with('product')->get();
        return \SuccessData(__('public.product_details_retrieved'), ProductDetailResource::collection($productDetails));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ProductDetailRequest $request)
    {
        ProductDetail::create($request->validated());
        return \Success(__('public.product_detail_created'));
    }

    /**
     * Display the specified resource.
     */
    public function show(Product $productDetail)
    {
        return \SuccessData(
            __('public.product_detail_retrieved'),
            $productDetail->load('productDetails')
        );
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(ProductDetailRequest $request, ProductDetail $productDetail)
    {
        $productDetail->update($request->validated());
        return \SuccessData(__('public.product_detail_updated'), new ProductDetailResource($productDetail->load('product')));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ProductDetail $productDetail)
    {
        $productDetail->delete();
        return \SuccessData(__('public.product_detail_deleted'), null);
    }
}
