<?php

namespace App\Http\Resources;

use App\Models\Product;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $product = Product::where('id', $this->product_id)->first();
        return [
            'id' => $this->id,
            // 'order_id' => $this->order_id,
            // 'product_id' => $this->product_id,
            'quantity' => $this->quantity,
            // 'price' => $this->price,
            // 'created_at' => Carbon::parse($this->created_at)->format('Y-m-d'),
            // 'order' => new OrderResource($this->whenLoaded('order')),
            'product' => new ProductResource($product),
        ];
    }
}
