<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $fillable = [
        'name',
        'description',
        'price',
        'original_price',
        'category_id',
        'image',
        'discount',
        'is_stock',
        'spacial',
    ];
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];
    // protected $casts = [
    //     'price' => 'float',
    //     'original_price' => 'float',
    //     'discount' => 'integer',
    //     'is_stock' => 'boolean',
    // ];

    /**
     * Get the category that the product belongs to.
     */
    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    /**
     * Get the order items for the product.
     */
    public function orderItems()
    {
        return $this->hasMany(OrderItem::class);
    }

    /**
     * Get the product tags for the product.
     */
    public function productTags()
    {
        return $this->hasMany(ProductTag::class);
    }

    /**
     * Get the tags for the product through product tags.
     */
    public function tags()
    {
        return $this->belongsToMany(Tag::class, 'product_tags');
    }

    /**
     * Get the product details for the product.
     */
    public function productDetails()
    {
        return $this->hasMany(ProductDetail::class);
    }
}
