<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductTag extends Model
{
    protected $fillable = [
        'product_id',
        'tag_id',
    ];

    /**
     * Get the product that owns the product tag.
     */
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    /**
     * Get the tag that owns the product tag.
     */
    public function tag()
    {
        return $this->belongsTo(Tag::class);
    }
}
