<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Tag extends Model
{
    protected $fillable = [
        'name',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * Get the product tags for the tag.
     */
    public function productTags()
    {
        return $this->hasMany(ProductTag::class);
    }

    /**
     * Get the products for the tag through product tags.
     */
    public function products()
    {
        return $this->belongsToMany(Product::class, 'product_tags');
    }
}
