<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Interfaces\PublicRepositoryInterface;
use App\Repositories\PublicRepository;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->bind(PublicRepositoryInterface::class, PublicRepository::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
