<?php

namespace Database\Seeders;

use App\Models\Media;
use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class AdminsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::firstOrCreate(['email' => 'superAdmin@gmail.com'], ['name' => 'superAdmin', 'phone' => '0900000000', 'password' => '123456789']);
        $user1 = User::firstOrCreate(['email' => 'abd@gmail.com'], ['name' => 'Abdulrouf Oyoun', 'phone' => '0988929807', 'password' => '123456789']);
        $user2 = User::firstOrCreate(['email' => 'anas@gmail.com'], ['name' => 'Anas Zarzer', 'phone' => '0945734346', 'password' => '123456789']);

        Role::firstOrCreate(['name' => 'superAdmin', 'guard_name' => 'api']);
        Role::firstOrCreate(['name' => 'admin', 'guard_name' => 'api']);

        $user->assignRole('superAdmin');
        $user1->assignRole('superAdmin');
        $user2->assignRole('superAdmin');

        Media::created(['name' => 'instagram', 'url' => 'd']);
        Media::created(['name' => 'telegram', 'url' => 'd']);
        Media::created(['name' => 'whatsapp', 'url' => 'd']);
    }
}
