<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\HomeAdController;
use App\Http\Controllers\MediaController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\OrderItemController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProductDetailController;
use App\Http\Controllers\ProductTagController;
use App\Http\Controllers\TagController;
use App\Models\Category;
use Illuminate\Support\Facades\Route;


// Auth
Route::post('/login', [AuthController::class, 'login']);
Route::post('/signUp', [AuthController::class, 'signUp']);


// Categories
Route::apiResource('categories', CategoryController::class);
Route::get('category/products', [ProductController::class, 'indexCategory']);
Route::get('categories-products', [CategoryController::class, 'all']);


// Tags
Route::apiResource('tags', TagController::class);

// Products
Route::apiResource('products', ProductController::class);
Route::get('search-product', [ProductController::class, 'search']);
Route::get('special-products', [ProductController::class, 'specialIndex']);


// Product Details
Route::apiResource('product-details', ProductDetailController::class);

// Product Tags
Route::apiResource('product-tags', ProductTagController::class);

// Home Ads
Route::apiResource('home-ads', HomeAdController::class);
// Media
Route::get('/show_media', [MediaController::class, 'index']);


Route::group(
    ['middleware' => ['auth:api']],
    function () {
        // Auth
        Route::delete('/logout', [AuthController::class, 'logout']);
        Route::post('/update_fcmtoken', [AuthController::class, 'updateFcmToken']);
        // Orders
        Route::get('orders', [OrderController::class, 'index']);
        Route::post('orders', [OrderController::class, 'store']);
        Route::get('orders/{order}', [OrderController::class, 'show']);
        Route::get('cancel-orders/{order}', [OrderController::class, 'cancelOrder']);

        // Order Items
        Route::apiResource('order-items', OrderItemController::class);
    }
);

// Super Admin routes
Route::group(
    ['middleware' => ['auth:api', 'role:superAdmin|admin']],
    function () {
        // Categories admin
        Route::post('categories', [CategoryController::class, 'store']);
        Route::put('categories/{category}', [CategoryController::class, 'update']);
        Route::delete('categories/{category}', [CategoryController::class, 'destroy']);

        // Tags admin
        Route::post('tags', [TagController::class, 'store']);
        Route::put('tags/{tag}', [TagController::class, 'update']);
        Route::delete('tags/{tag}', [TagController::class, 'destroy']);

        // Products admin
        Route::post('products', [ProductController::class, 'store']);
        Route::put('products/{product}', [ProductController::class, 'update']);
        Route::delete('products/{product}', [ProductController::class, 'destroy']);

        // Home Ads admin
        Route::post('home-ads', [HomeAdController::class, 'store']);
        Route::delete('home-ads/{homeAd}', [HomeAdController::class, 'destroy']);

        // Orders admin
        Route::put('orders/{order}', [OrderController::class, 'update']);
        Route::delete('orders/{order}', [OrderController::class, 'destroy']);

        // Order Items admin
        Route::post('order-items', [OrderItemController::class, 'store']);
        Route::put('order-items/{orderItem}', [OrderItemController::class, 'update']);
        Route::delete('order-items/{orderItem}', [OrderItemController::class, 'destroy']);

        // Product Details admin
        Route::post('product-details', [ProductDetailController::class, 'store']);
        Route::put('product-details/{productDetail}', [ProductDetailController::class, 'update']);
        Route::delete('product-details/{productDetail}', [ProductDetailController::class, 'destroy']);

        // Product Tags admin
        Route::post('product-tags', [ProductTagController::class, 'store']);
        Route::put('product-tags/{productTag}', [ProductTagController::class, 'update']);
        Route::delete('product-tags/{productTag}', [ProductTagController::class, 'destroy']);

        // Notifications
        Route::post('/send_notification', [NotificationController::class, 'sendBroadcastToAllUsers']);

        // Media
        Route::post('/update_media/{media}', [MediaController::class, 'update']);
    }
);

Route::get('login_error', [AuthController::class, 'loginError'])->name('login');
